package Ex31__3
  // J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
  // Edition : 1
  // Chapter : 31 Numerical methods
  // Illustrative Example 31.3 Page Number 493
  // Title - Newton Raphson Method
  //========================================================================
 model Ex33_3
 // Given:  The friction factor for smooth tubes is approximated to be f=0.079*(Re^-0.25)
 //Average velocity in the system involving the flow of water at 60degF is given by
 //v=(2180/((213.5*Re^-0.25)+10))^0.5
 //simplifying these to equations we get 213.5 * v ^ 2 + 105.03 * v ^ 2.25 - 22896.08 * v ^ 0.25=0
 
//============================================
///////Variable section///////////////////////////
    Real v[6](each unit = "ft/s")"Velocity";
    Real averagev(unit = "ft/s")"Average Velocity";
//==============================================
 //Equation Section
  equation
    v[1] = 5;//Intial guess of 5 ft/s
   // The iterative process is carried until the result converges
    for i in 1:5 loop
      v[i + 1] = Ex31_3a(v[i]);
    end for;
    averagev = v[6];
  end Ex33_3;

  function Ex31_3a
    input Real v;//Inputing the value of v in ft/s;
    output Real velocity;//Outputing the value of v in ft/s
  protected
    Real fv;//Function f(v)
    Real dfv;//Deravative of the Function
  algorithm
    fv := 213.5 * v ^ 2 + 105.03 * v ^ 2.25 - 22896.08 * v ^ 0.25;
    dfv := 427 * v + 236.313 * v ^ 1.25 - 5724.02 * (1 / v ^ 0.75);
    velocity := v - fv / dfv;
  end Ex31_3a;
end Ex31__3;
