package Ex31__4
 // J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
  // Edition : 1
  // Chapter : 31 Numerical methods
  // Illustrative Example 31.4 Page Number 497
  // Title - Simpson's 3 point Rule
  //========================================================================
model Ex31_4
//////Parameter section///////////////////////
    //============================================
    parameter Real upper=0.468"Upper Limit";
    parameter Real x0=0"Lower Limit";
//=============================================
///////Variable section///////////////////////////
    Real I"Integrated value representing the volume requirement for a tubular flow reactor";
    Real h"Value of h";
    Real x1"Value of x1";
    Real x2"Value of x2";
    Real ya"Coresponding y value when x=0";
    Real yb"Coresponding y value when x=x2";
    Real yab"Coresponding y value when x=x1";
//==============================================
//Equation Section
  equation
    h=upper/2;//Dividing the integral to two parts
    x1=x0+h;
    x2=x1+h;
    ya=Ex31_4a(x0);
    yab=Ex31_4a(x1);
    yb=Ex31_4a(x2);
//Applying Simpson 3 point rule
    I=(h/3)*(ya+(4*yab)+yb);    
//Remark:The answer provided in the textbook for y(a+b)/2 is wrong.Calculation error.
//=========================================================================
  end Ex31_4;
function Ex31_4a
input Real x;//Input the value of x
output Real y;//output the value of y
algorithm
y := (1-(0.4*x))^2/(((1-x)*(1-(0.4*x)))-(1.19*(x^2)));
end Ex31_4a;
end Ex31__4;
