// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 32 Economics and Finance
// Illustrative Example 32.5 Page Number 512
// Title - Total cost for the fluid transportation
//========================================================================
model Ex32_5
//////Parameter section///////////////////////
//============================================
    parameter Real OCa(unit="$/yr")=20000  "Pressure Drop costs for the two inch pipe";
    parameter Real CRF=0.1                  "Capital recovery factor for both pipe";
    parameter Real d(unit="miles")=4        "Distance of the pipe";
    parameter Real ca(unit="$/ft")=1       "2 Inch pipe cost per foot";
    parameter Real cb(unit="$/ft")=6       "4 inch pipe cost per foot";
//============================================= 
///////Variable section///////////////////////////      
    Real CCa(unit="$")                     "Capital cost for the 2 inch pipe";
    Real CCb(unit="$")                     "Capital cost for the 4 inch pipe";
    Real TCa(unit="$")                     "Total cost for the 2 inch pipe";
    Real TCb(unit="$")                     "Total cost for the 4 inch pipe";
    Real OCb(unit="$/yr")                  "Operating cost for the 4 inch pipe";
//============================================== 
//Equation Section    
equation
    OCb=OCa/16;//As Pressure drop for the 4 inch pipe is 1/16  of the pressure drop for the 2 inch pipe
    CCa=(d*5280*ca*CRF);//Converting miles to ft
    CCb=(d*5280*cb*CRF);//Converting miles to ft
    TCa=OCa+CCa;
    TCb=OCb+CCb;//As TCb< TCa It is more economical.
end Ex32_5;
// Remark: The answers providied for CCa,CCb,TCa,TCb in the textbook is wrong.Calculation Error.
//=========================================================================
