package Ex32_6
// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 32 Economics and Finance
// Illustrative Example 32.6 Page Number 512
// Title - Particulate control device.
//========================================================================
  model Ex32_6a
  //////Parameter section///////////////////////
  //============================================
      parameter Real q(unit="ft^3/min")=50000        "Volumetric flow rate";
      parameter Real c(unit="gr/ft^3")=2             "Inlet loading of dust";
      parameter Real DV(unit="$/lb")=0.03            "Value of dust";
      parameter Real Ce(unit="$/kW.h")=0.18          "Cost of electricity";
      parameter Real Ef=0.55                         "Efficiency of the fan";
  //=============================================
    ///////Variable section///////////////////////////
      Real DelP(unit="lbf/ft^2")                     "Pressure drop";
      Real E                                         "Fractional collection efficiency";
      Real CP(unit="$/min")                          "Cost of power";
      Real RV(unit="$/min")                          "Recovered value";
  //==============================================
    //Equation Section
  equation
      DelP=Ex32__6(q);
      E=DelP/(DelP+15);
      RV=(q*((c/7000)*DV*E));//Converting gr/ft^3 to lb/ft^3
      CP=(q*Ce*DelP)/(44200*Ef*60);//Converting  kW to ft.lbf/min and h to min
  //Remark: The  answer given in the book for DelP is wrong.Calculation error.
  end Ex32_6a;
function Ex32__6
    input Real q;//Intput the value of volumetric flow rate in ft^3/min
    output Real DelP;//Output the value DelP in lbf/ft^2
    protected
    parameter Real c=2/7000;//Inlet loading of dust in lb/ft^3
    parameter Real DV=0.03;//Value of dust in $/lb
    parameter Real Ce=0.18;//Cost of electricity in $/kW.h
    parameter Real Ef=0.55;// Efficiency of fan
algorithm
//Dividing eqn RV and CP by DelP  and equating them to determine DelP.
  DelP :=((q*c*DV)/((q*Ce)/(44200*Ef*60)))-15;
end Ex32__6;
end Ex32_6;
