// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 33 Biomedical Engineering
// Illustrative Example 33.5 Page Number 527
// Title - Ratio of diameters.
//========================================================================
model Ex33_5
//////Parameter section///////////////////////
//============================================ 
    parameter Real S=1        "Area of the inlet artery";
//============================================= 
///////Variable section///////////////////////////    
    Real S1                   "Area of the outlet artery";
    Real D_D1                 "Ratio of diameters at the inlet";
    Real D1_D                 "Ratio of the diameters at the outlet";
//============================================== 
//Equation Section    
equation
  D_D1=((S/S1)^0.5);
  S1=S/2;//As the artery branches into two equal area i.e. S1+S2=S 
  D1_D=1/D_D1;
end Ex33_5;
//========================================================================
