// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 33 Biomedical Engineering
// Illustrative Example 33.6 Page Number 528
// Title - velocity of blood
//========================================================================
model Ex33_6
//////Parameter section///////////////////////
//============================================
  parameter Real a_in(unit="m^2")=0.2                   "Area at the inlet";
  parameter Real a1(unit="m^2")=0.08                    "Area at branch 1";
  parameter Real a2(unit="m^2")=0.025                   "Area at branch 2";
  parameter Real a3(unit="m^2")=0.031                   "Area at branch 3";
  parameter Real vin(unit="mm/s")=5                     "Velocity at the inlet";
  parameter Real v1(unit="mm/s")=7                      "Velocity at branch 1";
  parameter Real v2(unit="mm/s")=12                     "Velocity at branch 2";
//============================================= 
///////Variable section///////////////////////////   
  Real q(unit="mm^3/s")                                 "Volumetric flow rate at inlet ";
  Real q1(unit="mm^3/s")                                "Volumetric flow rate at branch 1 ";
  Real q2(unit="mm^3/s")                                "Volumetric flow rate at branch 2 ";
  Real q3(unit="mm^3/s")                                "Volumetric flow rate at branch 3";           
  Real v3(unit="mm/s")                                  "Velocity at branch 3";
//============================================== 
//Equation Section     
equation
  q=vin*a_in;
  q1=v1*a1;
  q2=v2*a2;
  q=q1+q2+q3;//Continuity equation is applied 
  q3=v3*a3;
end Ex33_6;
//=========================================================================
