// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 5 Newtonian fluids 
// Illustrative Example 5.2 Page Number 42
// Title - Shear stress required
//========================================================================
model Ex5_2
//////Parameter section///////////////////////
//============================================
    parameter Real x2(unit="ft")=0.0833              "Distance of the stationary plate from moving plate";
    parameter Real x1(unit="ft")=0                   "Moving plate taken as reference";
    parameter Real v1(unit="ft/min")=5               "Velocity of the moving plate";
    parameter Real v2(unit="ft/hr")=0                "Velocity of the stationary plate";
    parameter Real neu(unit="ft^2/hr")=1.66          "Kinematic viscosity";
    parameter Real rho(unit="lb/ft^3")=0.08          "Density of the fluid";
    parameter Real gc(unit="ft.lb/lbf.hr^2")=4.17E8  "Conversion constant";
//============================================= 
///////Variable section///////////////////////////    
    Real tou_xy(unit="lbf/ft^2")                "Shear stress required" ;
//============================================== 
//Equation Section    
equation
  tou_xy=(-1*neu*rho*(v2-(v1*60))/(x2-x1))/gc;//Conversion of  v1 from ft/min to ft/hr
end Ex5_2;
//============================================================================
