// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 5 Newtonian fluids 
// Illustrative Example 5.3 Page Number 45
// Title - Shear stress calculated by the viscometer
//========================================================================
model Ex5_3
//////Parameter section///////////////////////
//============================================
    final constant Real pi=Modelica.Constants.pi"The value of pi";
    parameter Real D(unit="ft")=0.25            "Diameter of the inner cylinder";
    parameter Real L(unit="ft")=0.5             "Height of the inner cylinder";
    parameter Real T(unit="ft.lbf")=15.3        "Given torque";
//============================================= 
///////Variable section///////////////////////////
    Real F(unit="lbf")                         "Force";
    Real tou(unit="psf")                       "Shear stress";
//============================================== 
//Equation Section
equation
     F=(2*T)/D;
     tou= F/(pi*D*L);//As per equation 5.11
end Ex5_3;
//============================================================================
