// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 7 Conservation Law For Mass
// Illustrative Example 7.2 Page Number 65
// Title - Mass and Volumetric  flow rate
//========================================================================
model Ex7_2
//////Parameter section///////////////////////
//============================================
  final constant Real pi=Modelica.Constants.pi          "The value of pi";
  parameter Real D1(unit="m")=0.14                      "Diameter of pipe at section 1";
  parameter Real D2(unit="m")=0.07                      "Diameter of pipe at section 2";
  parameter Real v1(unit="m/s")=2                       "Velocity of fluid at section 1";
  parameter Real rho(unit="kg/m^3")=1000                "Density of the fluid";
//============================================= 
///////Variable section///////////////////////////
  Real S1(unit="m^2")                                   "Cross sectional area at section 1"; 
  Real q1(unit="m^3/s")                                 "Volumetric flow rate at section 1";
  Real G(unit="kg/m^2.s")                               "Mass flux";
  Real q2(unit="m^3/s")                                 "Volumetric flow rate at section 2";
  Real v2(unit="m/s")                                   "Velocity of the fluid at section 2";
  Real m1(unit="kg/s")                                  "Mass flow rate at section 1";
//============================================== 
//Equation Section
equation
  S1=pi*(D1^2)/4;
  q1=S1*v1;
  m1=rho*q1;
  G=m1/S1;//As per equation 7.4
  q2=q1;
  v2=(v1*D1^2)/(D2^2);  
end Ex7_2;
//Remark:The answer may slightly vary due to  rounding off values.
//============================================================================
