// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 7 Conservation Law For Mass
// Illustrative Example 7.3 Page Number 66
// Title - Velocity of the fluid.
//========================================================================
model Ex7_3
//////Parameter section///////////////////////
//============================================
    parameter Real rho(unit="kg/m^3")=800             "Density of the fluid";
    parameter Real v1(unit="m/s")=5                   "Velocity of the fluid at section 1";
    parameter Real S1(unit="m^2")=0.2                 "Cross sectional area at section 1";
    parameter Real v2(unit="m/s")=7                   "Velocity of the fluid at section 2";
    parameter Real S2(unit="m^2")=0.3                 "Cross sectional area at section 2";
    parameter Real v3(unit="m/s")=12                  "Velocity of the fluid at section 3";
    parameter Real S3(unit="m^2")=0.25                "Cross sectional area at section 3";
    parameter Real S4(unit="m^2")=0.15                "Cross sectional area at section 4";
//============================================= 
///////Variable section///////////////////////////
    Real q1(unit="m^3/s")                             "Volumetric flow rate at section 1";
    Real q2(unit="m^3/s")                             "Volumetric flow rate at section 2";
    Real q3(unit="m^3/s")                             "Volumetric flow rate at section 3";
    Real q4(unit="m^3/s")                             "Volumetric flow rate at section 4";
    Real v4(unit="m/s")                               "Velocity of the fluid at section 4";
    Real m4(unit="kg/s")                              "Mass flow rate at section 4";
//============================================== 
//Equation Section
equation
    q1=v1*S1;
    q2=v2*S2;
    q3=v3*S3;
    q4=q1+q2-q3;
    v4=q4/S4;
    m4=rho*q4;   
end Ex7_3;
//============================================================================
