// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 8 Conservation Law For Energy 
// Illustrative Example 8.1 Page Number 75 
// Title - Outlet Temperature.
//========================================================================
model Ex8_1
//////Parameter section///////////////////////
//============================================
    parameter Real Cp(unit="J/kg.degC")=1090           "Average heat capacity";
    parameter Real m(unit="kg/s")=9                    "Mass flow rate";
    parameter Real T1(unit="degC")=650                 "Inlet temperature";
    parameter Real Q(unit="W")=5.5E6                   "Heat that is transferred";
//============================================= 
///////Variable section///////////////////////////
    Real T2(unit="degC")                               "Outlet temperature";
//============================================== 
//Equation Section
equation
    T2=(-Q/(m*Cp))+T1;//Negative sign is included as the heat is transferring out from the gas
end Ex8_1;
//============================================================================
