// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 8 Conservation Law For Energy 
// Illustrative Example 8.5 Page Number 81 
// Title - Time taken for the liquid to drop a certain height
//========================================================================
model Ex8_5
//////Parameter section///////////////////////
//============================================
    parameter Real z1(unit="m")=9        "Intial water level";
    parameter Real h2(unit="m")=1        "Liquid level to drop to this height";
    parameter Real D1(unit="m")=3        "Diameter of the tank";
    parameter Real D2(unit="m")=0.3      "Diameter of the outlet";
    parameter Real g(unit="m/s^2")=9.807 "Acceleration due to gravity";
//============================================= 
///////Variable section///////////////////////////
    Real t(unit="s")  "Time taken for the water level to drop from 9 m to 1 m";
    Real a_g          "a/g ratio";
//============================================== 
//Equation Section
equation
  t=(2*((z1^0.5)-(h2^0.5)))/(((2*g)^0.5)*((D2/D1)^2));
  a_g=-(D2/D1)^2;//This gives us that the maximum acceleration is 1 % of g hence bernoullis equation can be used.
end Ex8_5;
//============================================================================


