// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 10 Law Of Hydrostatics
// Illustrative Example 10.5 Page Number 103
// Title - Hydrometer
//========================================================================
model Ex10_5
//////Parameter section///////////////////////
//============================================
  final constant Real pi=Modelica.Constants.pi             "The value of pi";
  parameter Real F(unit="N")=0.13                          "Total hydrometer weight";
  parameter Real SG=1.3                                    "Specific gravity";
  parameter Real D(unit="m")=0.008                         "Diameter of the stem";
  parameter Real rho(unit="kg/m^3")=1000                   "Density of water";
  parameter Real g(unit="m/s^2")=9.807                     "Acceleration due to gravity";
//============================================= 
///////Variable section///////////////////////////
  Real h(unit="mm")                                        "Height at which hydrometer will float";
//============================================== 
//Equation Section
equation
  h=(4*F*(1-(1/SG)))/(pi*(D^2)*rho*g)*10^3;//Converting m to mm
end Ex10_5;
//============================================================================

