// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 11 Ideal gas law 
// Illustrative Example 11.3 Page Number 114
// Title - Actual volumetric flow rate
//========================================================================
model Ex11_3
//////Parameter section///////////////////////
//============================================
    parameter Real qs(unit="scfm")=2000"Standard Volumetric flow rate";
    parameter Real Ps(unit="atm")=1    "Standard pressure";
    parameter Real Ts(unit="degF")=60  "Standard temperature";
    parameter Real Ta(unit="degF")=700 "Actual temperature";
    parameter Real Pa(unit="atm")=1    "Actual pressure";
//============================================= 
///////Variable section///////////////////////////
    Real qa(unit="acfm")               "Actual volumetric flow rate";
//============================================== 
//Equation Section
equation
  qa=qs*((Ta+460)/(Ts+460))*(Ps/Pa);//Temperature  converted from degF to degR
end Ex11_3;
//============================================================================


