package Ex11__7
  // J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
  // Edition : 1
  // Chapter : 11 Ideal gas law
  // Illustrative Example 11.7 Page Number 118
  // Title - Molar volume of methane
  //=======================================================================

  model Ex11_7
    //////Parameter section///////////////////////
    //============================================
    parameter Real R(unit = "atm.ft^3/lbmol.degR") = 0.73 "Gas constant";
    parameter Real T_c(unit = "K") = 190.6            "Critical temperature";
    parameter Real Pc(unit = "atm") = 45.4            "Critical pressure";
    parameter Real P(unit = "atm") = 10               "Pressure";
    parameter Real T_k(unit = "K") = 373              "Temperature";
    //=============================================
    ///////Variable section///////////////////////////
    Real T(unit="degR")                  "Temperature"; 
    Real Tc(unit="degR")                 "Critical temperature";
    Real a                               "RK constant";
    Real b                               "RK constant";
    Real V[5](each unit = "ft^3/lbmol")  "Molar volume";
    Real V1(unit = "ft^3/lbmol")         "Molar volume of methane gas";
    //==============================================
    //Equation Section
  equation
    T=T_k*1.8;//Conversion of K to degR
    Tc=T_c*1.8;//Conversion of K to degR
    a = 0.42748 * R ^ 2 * Tc ^ 2.5 / Pc;
    b = 0.08664 * R * Tc / Pc;
    V[1] = 0;//Initial Value.
    //Performig trial and error until consecutive values are aprroximately same.
    for i in 1:4 loop
      V[i + 1] = Ex11_7a(V[i]);
    end for;
    V1 = V[4];
//============================================================================
  end Ex11_7;

  function Ex11_7a
    input Real V;//Input the value of specific volume in ft^3/lbmol
    output Real Vnew;//Output the  new value of specific volume in ft^3/lbmol
  protected
    Real a;//RK constant
    Real b;//RK constant
    parameter Real R = 0.73;//Gas constant in atm.ft^3/lbmol.degR
    parameter Real Tc = 190.6*1.8;//Critical temperature in degR
    parameter Real Pc = 45.4;//Critical pressure in atm
    parameter Real P = 10;//Pressure in atm
    parameter Real T = 373 * 1.8;//Temperature in degR
  algorithm
    a := 0.42748 * R ^ 2 * Tc ^ 2.5 / Pc;
    b := 0.08664 * R * Tc / Pc;
    Vnew := (R * T ^ 1.5 * V * (V + b) - a * (V - b)) / (P * (V - b) * (V + b) * T ^ 0.5);
  end Ex11_7a;
end Ex11__7;
