// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 12 Flow mechanisms 
// Illustrative Example 12.7 Page Number 130
// Title - Average velocity of the fluid
//========================================================================
model Ex12_7
//////Parameter section///////////////////////
//============================================
    final constant Real pi=Modelica.Constants.pi    "The value of pi";
    parameter Real D(unit="ft")=1.2                 "Diameter of the duct";
    parameter Real T(unit="degF")=300               "Given Temperature";
    parameter Real P(unit="atm")=1                  "Given pressure";
    parameter Real Ts(unit="degF")=60               "Standard Temperature";
    parameter Real Ps(unit="atm")=1                 "Standard pressure";
    parameter Real qs(unit="scfm")=1000             "Standard volumetric flow rate";
    parameter Real MW=33                            "Molecular weight";
    parameter Real R(unit="atm.ft^3/lbmol.degR")=0.7302"Gas constant";
    parameter Real Dm(unit="m")=0.366               "Diameter  of the duct in m";
    parameter Real meu(unit="kg/m.s")=2.2E-5        "Viscosity of the fluid";
//============================================= 
///////Variable section///////////////////////////    
    Real Re                          "Reynolds number";
    Real rhom(unit="kg/m^3")         "Density of the gas";
    Real rho(unit="lb/ft^3")         "Density of the gas from ideal gas law";
    Real q(unit="acfm")              "Actual Volumetric flow rate" ;
    Real S(unit="ft^2")              "Cross sectional area";
    Real m(unit="kg/s")              "Mass flow rate";
    Real v(unit="ft/s")              "Average velocity of the fluid";
    Real vm(unit="m/s")              "Average Velocity of the fluid in m/s";
    Real Sm(unit="m^2")              "Cross sectional area in m^2";
//============================================== 
//Equation Section
equation
  q=qs*((T+460)/(Ts+460))*(Ps/P);//Conversion of degF to degR
  S=pi*(D^2)/4;
  Sm=0.092903*S;//Conversion of ft^2 to m^2
  v=(q/S)/60;//Conversion of min to s
  rho=(P*MW)/(R*(T+460));
  m=rho*v*S/2.205;//Conversion of lb/s to kg/s
  vm=v*0.3048;//Conversion of ft/s to m/s
  rhom=rho*(16.0185);//Conversion of lb/ft^3 to kg/m^3
  Re=Dm*vm*rhom/meu;
end Ex12_7;
// Remark : Printing mistake in the  value of S in m=rho*v*S expression.The value of Re differs due to rounding off values.
//============================================================================


