// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 13 Laminar flow in pipes 
// Illustrative Example 13.1 Page Number 136
// Title - Average velocity of various fluid
//========================================================================
model Ex13_1
//////Parameter section///////////////////////
//============================================
    parameter Real Re=2100                         "Reynolds number for Laminar flow";
    parameter Real meuw(unit="lb/ft.s")=6.72E-4    "Viscosity of water";
    parameter Real rhow(unit="lb/ft^3")=62.4       "Density of  water";
    parameter Real Dw(unit="in")=2.067             "Diameter of pipe for flowing water";
    parameter Real meua(unit="lb/ft.s")=12.1E-6    "Viscosity of air";
    parameter Real rhoa(unit="lb/ft^3")=0.1024     "Density of  air";
    parameter Real Da(unit="in")=2.067             "Diameter of pipe for flowing air";
    parameter Real meuo(unit="cP")=300             "Viscosity of oil";
    parameter Real SG=0.92                         "Specific gravity of  oil";
    parameter Real Do(unit="in")=4.026             "Diameter of pipe for flowing oil";
//============================================= 
///////Variable section///////////////////////////
    Real vo(unit="ft/s")                           "Velocity of  oil";
    Real va(unit="ft/s")                           "Velocity of  air";
    Real vw(unit="ft/s")                           "Velocity of  water";
//============================================== 
//Equation Section
equation
    vw=Re*meuw/((Dw/12)*rhow);
    va=Re*meua/((Da/12)*rhoa);
    vo=Re*(meuo*6.72E-4)/((Do/12)*SG*62.4);//Conversion of cP to lb/ft.s and SG to Density of oil.
end Ex13_1;
//============================================================================


