// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,          USA, 2009.
// Edition : 1
// Chapter : 14 Turbulent flow in pipes 
// Illustrative Example 14.1 Page Number 148
// Title - Reynolds number 
//========================================================================
model Ex14_1
//////Parameter section///////////////////////
//============================================
    parameter Real meu(unit="g/cm.s")=0.78E-2"Viscosity of the fluid";
    parameter Real rho(unit="g/cm^3")=1.50   "Density  of the fluid";
    parameter Real D(unit="cm")=2.54         "Diameter of the tube";
    parameter Real v(unit="cm/s")=20         "Velocity of the fluid";
//============================================= 
///////Variable section///////////////////////////
    Real Re                                  "Reynolds number";
//============================================== 
//Equation Section    
equation
    Re=D*v*rho/meu;//As Re >2100 The flow is turbulent.
end Ex14_1;
//============================================================================
