// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 14 Turbulent flow in pipes 
// Illustrative Example 14.11 Page Number 164
// Title - Volumetric flow rate 
//========================================================================
model Ex14_11
//////Parameter section///////////////////////
//============================================
    final constant Real pi=Modelica.Constants.pi  "The value of pi";
    parameter Real D(unit="in")=2                 "Inner diameter of the pipe";
    parameter Real vzmax(unit="ft/min")=30        "Maximum velocity";
//============================================= 
///////Variable section///////////////////////////    
    Real q_plug(unit="ft^3/min")"Volumetric flow rate for the plug flow characteristics";
    Real vz_lam(unit="ft/min")  "Velocity of the fluid  for the Laminar flow ";
    Real A(unit="ft^2")         "Cross sectional area";
    Real vz_tur(unit="ft/min")  "Velocity of the fluid for the turbulent flow ";
    Real q_tur(unit="ft^3/min") "Volumetric flow rate for the turbulent flow";
    Real q_lam(unit="ft^3/min") "Volumetric flow rate for the Laminar flow ";
    Real vz_plug(unit="ft/min") "Velocity of the fluid for the plug flow characteristics";
//============================================== 
//Equation Section
equation
    A=pi*(D/12)^2/4;//Converting in to ft.
    vz_lam=(1/2)*vzmax;//For Laminar flow characteristics
    q_lam=vz_lam*A;
    vz_plug=vzmax;//For plug flow characteristics
    q_plug=vz_plug*A;
    vz_tur=(0.816)*vzmax;//For turbulent flow characteristics
    q_tur=vz_tur*A;
end Ex14_11;
//============================================================================
