// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 14 Turbulent flow in pipes 
// Illustrative Example 14.2 Page Number 148
// Title - Velocity required to make the flow turbulent 
//========================================================================
model Ex14_2
//////Parameter section///////////////////////
//============================================
  parameter Real meu(unit="cP")=1.03           "Viscosity of the fluid";
  parameter Real rho(unit="lb/ft^3")=62.4      "Density of the fluid";
  parameter Real D(unit="in")=1                "Diameter of the pipe ";
  parameter Real Re=2100                       "Reynolds number";
//============================================= 
///////Variable section///////////////////////////
  Real v(unit="ft/s")                          "Minimum velocity required to make the flow  turbulent" ;
//============================================== 
//Equation Section
equation
  v = Re*meu*12*6.72E-4/(D*rho);//Conversion from in to ft, cP to lb/ft.s
end Ex14_2;
//============================================================================
