// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 14 Turbulent flow in pipes 
// Illustrative Example 14.4 Page Number 154
// Title - Diameter of the pipe
//========================================================================
model Ex14_4
//////Parameter section///////////////////////
//============================================
    final constant Real pi= Modelica.Constants.pi "The value of pi";
    parameter Real w(unit="in")=2                 "Width of a rectangle";
    parameter Real h(unit="in")=10                "Height of the rectangle";
    parameter Real Do(unit="cm")=10               "Outer diameter of the annulus";
    parameter Real Di(unit="cm")=8                "Inner diameter of the annulus";
    parameter Real Dc(unit="cm")=10               "Diameter of the circular tube";
//============================================= 
///////Variable section///////////////////////////
     Real Deqa(unit="in")  "Diameter of the rectangular pipe";
     Real Deqb(unit="cm")  "Diameter of the annulus pipe";
     Real Deqc(unit="cm")  "Diameter of the half full circular pipe";     
//============================================== 
//Equation Section
equation
    Deqa=4*h*w/((2*h)+(2*w));//Printing mistake in the Perimeter of rectangle expression 
    Deqb=4*(pi/4)*(Do^2-Di^2)/(pi*(Do+Di));//As per equation 14.15
    Deqc=4*(pi*(Dc^2)/8)/(pi*Dc/2);
end Ex14_4;
// Remark:Printing mistake in the expression of Deqb.
//============================================================================
