// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 14 Turbulent flow in pipes 
// Illustrative Example 14.5 Page Number 157
// Title - Diameter of the pipe  and fluid velocity
//========================================================================
model Ex14_5
//////Parameter section///////////////////////
//============================================    
    final constant Real pi=Modelica.Constants.pi        "The value of pi";
    parameter Real MW(unit="lb/lbmol")=28.9             "Molecular weight of air";
    parameter Real R(unit="psi.ft^3/lbmol.degR")=10.73  "Gas constant";
    parameter Real T(unit="degR")=500                   "Temperature";
    parameter Real P(unit="psia")=14.75                 "Pressure";
    parameter Real q(unit="ft^3/s")=8.33                "Volumetric flow rate";
    parameter Real L(unit="ft")=800                     "Length of the pipe";
    parameter Real P1(unit="psig")=0.1                  "Pressure at the inlet";
    parameter Real P2(unit="psig")=0.01                 "Pressure at the delivery";
    parameter Real meu(unit="lb/ft.s")=1.14E-5          "Viscosity of the fluid";
    parameter Real k(unit="in")=0.00006                 "Roughness of sheet metal" ;
    parameter Real Dassume(unit="ft")=1                 "Assumed diameter";
    parameter Real gc(unit="lb.ft/lbf.s^2")=32.174      "Conversion constant";
//============================================= 
///////Variable section///////////////////////////
    Real f1                            "Fanning Friction factor determined using Re_assume";
    Real Re_assume                     "Reynolds number calculated using the assumed diameter";
    Real k_D_1                         "Relative roughness from the assumed D value";
    Real rho(unit="lb/ft^3")           "Density of the fluid";
    Real D1(unit="ft")                 "Diameter determined from the first iteration";
    Real D_lam(unit="ft")              "Diameter determined assuming laminar flow";
    Real Re_lam                        "Reynolds number";
    Real k_D_2                         "Relative roughness in the second iteration";
    Real f2                            "Fanning Friction factor determined using Re2";
    Real D(unit="ft")                  "Diameter of the pipe from the second iteration";
    Real v(unit="m/s")                 "Velocity of the fluid";
    Real Re2                           "Reynolds number from the second iteration";
//============================================== 
//Equation Section    
equation
  rho=P*MW/(R*T);
//Assuming it is Laminar flow
  D_lam=((128*meu*L*q)/(pi*(P1-P2)*144))^0.25;
  Re_lam=4*q*rho/(pi*D_lam*meu);//Since Re > 2100 It is not laminar flow.
//Assuming the value of pipe diameter D=1 ft and carrying out the iteration.
  k_D_1=k/(12*Dassume);
  Re_assume=4*q*rho/(pi*Dassume*meu);
  f1=0.005;//Fanning Friction factor from Fig 14.2
  D1=((32*rho*f1*L*(q^2))/(gc*(pi^2)*(P1-P2)*144))^0.2;
  k_D_2=k/(12*D1);
  Re2=4*q*rho/(pi*D1*meu);
  f2=0.0045;//Fanning Friction factor from Fig 14.2
  D=((32*rho*f2*L*(q^2))/(gc*(pi^2)*(P1-P2)*144))^0.2;//Printing mistake of the expression in the book.
  v=q/(pi*(D^2)*3.281/4);//Coversion from ft to m
end Ex14_5;
//Remark:Printing mistake in the value of viscosity for D_lam in the formula hence the value differs in D_lam and in Re_lam
//============================================================================
