// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 14 Turbulent flow in pipes 
// Illustrative Example 14.6 Page Number 159
// Title - Velocity and tube diameter that is required 
//========================================================================
model Ex14_6
//////Parameter section///////////////////////
//============================================    
    final constant Real pi=Modelica.Constants.pi             "The value of pi";
    parameter Real rho(unit="kg/m^3")=789                    "Density of the fluid";
    parameter Real meu(unit="kg/m.s")=1.1E-3                 "Viscosity of the fluid";
    parameter Real k(unit="m")=1.5E-6                        "Tube roughness from table 14.1";
    parameter Real L(unit="m")=60                            "Length of the tube";
    parameter Real q(unit="m^3/s")=2.778E-3                  "Volumetric flow rate";
    parameter Real g(unit="m/s^2")=9.807                     "Acceleration due to gravity";
    parameter Real hf(unit="m")=30                           "Friction Loss";
    parameter Real neu(unit="m^2/s")=1.395E-6                "Kinematic viscosity";
//============================================= 
///////Variable section///////////////////////////    
    Real D(unit="m")                                  "Diameter of the tube";
    Real A(unit="m")                                  "Variable of the eqn which is equal to L*q^2/(g*hf)" ;                         
    Real S(unit="m^2")                                "Cross sectional area";
    Real v(unit="m/s")                                "Velocity of the fluid";
    Real Re                                           "Reynolds number";
//============================================== 
//Equation Section
equation
    A=L*q^2/(g*hf);
    D=0.66*(((k^1.25)*(A^4.75))+((meu*(A^5.2))/(q*rho)))^0.04;//As per eqn 14.20
    S=pi*(D^2)/4;
    v=q/S;
    Re= D*v/neu;//Since Re>4000 Hence it is turbulent flow
end Ex14_6;
//Remark: The  answer provided in the textbook is wrong for v. Calculation error .Hence the value of Re differs.
//============================================================================
