// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 14 Turbulent flow in pipes 
// Illustrative Example 14.8 Page Number 161
// Title - Pressure drop due to friction 
//========================================================================
model Ex14_8
//////Parameter section///////////////////////
//============================================
    parameter Real rho(unit="kg/m^3")=820       "Density of the fluid";
    parameter Real Re=60000                     "Reynolds number";
    parameter Real L(unit="m")=9                "Length of the pipe";
    parameter Real v(unit="m/s")=2.38           "Velocity of the fluid";
    parameter Real D(unit="m")=0.0493           "Diameter of the pipe";
    parameter Real g(unit="m/s^2")=9.807        "Acceleration due to gravity";
//============================================= 
///////Variable section///////////////////////////
    Real hf(unit="m of kerosene")          "Friction Loss";
    Real f                                 "Fanning friction factor";
    Real DelP(unit="atm")                  "Pressure drop";
//============================================== 
//Equation Section
equation
    f=0.046/Re^0.2;//As per equation 14.9
    hf=4*f*L*(v^2)/(D*2*g);
    DelP=(rho*g*hf)/10^5;//Conversion of Pa to atm
end Ex14_8;
//============================================================================


