// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 15 Compressible and sonic flow 
// Illustrative Example 15.3 Page Number 170
// Title - Speed of the sound when propane is flowing through the pipe
//========================================================================
model Ex15_3
//////Parameter section///////////////////////
//============================================
    parameter Real k=1.3                                "k value for propane";
    parameter Real T(unit="K")=290                      "Temperature";
    parameter Real M(unit="g/gmol")=44                  "Molecular weight of propane";
    parameter Real R(unit="L.Pa/gmol.K")=8314.4         "Gas constant";
    parameter Real v(unit="m/s")=43                     "Velocity of the fluid";
    parameter Real rho(unit="kg/m^3")=6.39              "Density of the fluid";
    parameter Real meu(unit="cP")=8E-3                  "Viscosity of the fluid";
    parameter Real D(unit="m")=0.0254                   "Diameter of the pipe";
//============================================= 
///////Variable section///////////////////////////    
    Real Re                     "Reynolds number";
    Real c(unit="m/s")          "Speed of light";
    Real Ma                     "Mach Number";
//============================================== 
//Equation Section
equation
  c=((k*R*T)/M)^0.5;
  Ma=v/c;//As Ma< 0.3 The fluid flow is incompressible
  Re=D*rho*v*10^3/meu;//Converting from cP to kg/m.s
//As Re > 4000 the flow is turbulent.
end Ex15_3;
//Remark: The answers providied for Re in the textbook is wrong.Calculation Error
//============================================================================
