//J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009. 
// Edition : 1
// Chapter : 16 Two phase flow 
// Illustrative Example 16.2 Page Number 183
// Title - Total Pressure Drop
//========================================================================
model Ex16_2
//////Parameter section///////////////////////
//============================================
 parameter Real X=1.66                         "Dimensionless Parameter";
 parameter Real DelP_zG(unit="psft/100ft")=2.71"Pressure Drop per 100 ft for the gas";
 parameter Real DelP_zL(unit="psft/100ft")=7.50"Pressure Drop per 100 ft for the Liquid";
//============================================= 
///////Variable section///////////////////////////
 Real DelP_Z(unit="psf/100 ft")"Total Pressure Drop per 100 ft from YG";
 Real DELP_Z(unit="psf/100 ft")"Total Pressure Drop per 100 ft from YL";
 Real YL_tt"Function of the variable X for liquid";
 Real YG_tt"Function of the variable X for gas";
//============================================== 
//Equation Section
equation
  YG_tt=5.80+(6.7143*X)+(6.9643*X^2)-(0.75*X^3);//As per the equation 16.16b
  DelP_Z=YG_tt*DelP_zG;
  YL_tt=18.219*(1/(X^0.8192));//As per the equation 16.17b
  DELP_Z=YL_tt*DelP_zL;
end Ex16_2;
//============================================================================



