// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 16 Two phase flow 
// Illustrative Example 16.3 Page Number 185
// Title - Pressure Drop for the gas and liquid phase
//========================================================================
model Ex16_3
//////Parameter section///////////////////////
//============================================
  parameter Real X=1.66                       "Dimensionless Parameter";
  parameter Real DelP_zG(unit="psft/100ft")=2.71"Pressure Drop per 100 ft for the gas";
  parameter Real DelP_zL(unit="psft/100ft")=7.50"Pressure Drop per 100 ft  for the Liquid";
//============================================= 
///////Variable section///////////////////////////
  Real YG_tv                    "Function of the variable X for gas";
  Real DelP_Z(unit="psf/100 ft")"Pressure Drop per 100 ft from YG";
  Real DELP_Z(unit="psf/100 ft")"Pressure Drop per 100 ft from YL";
  Real YL_tv                    "Function of the variable X for liquid";
//============================================== 
//Equation Section
equation
  YG_tv=20-(21.81*X)+(16.357*X^2)-(1.8333*X^3);//As per equation 16.19b
  DelP_Z=YG_tv*DelP_zG;
  YL_tv=11.702*(1/(X^0.7334));//As per equation 16.20b
  DELP_Z=YL_tv*DelP_zL;
end Ex16_3;
//============================================================================

