// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 16 Two phase flow 
// Illustrative Example 16.6 Page Number 191
// Title - Determinig the flow regime
//========================================================================
model Ex16_6
//////Parameter section///////////////////////
//============================================
  final constant Real pi=Modelica.Constants.pi         "The value of pi";
  parameter Real rhoa(unit="lb/ft^3")=0.075            "Density of air";
  parameter Real meua(unit="lb/ft.s")= 1.24E-5         "Viscosity of air";
  parameter Real qa(unit="ft^3/s")=5.3125              "Volumetric flow rate of air";
  parameter Real rhok(unit="lb/ft^3")=52.1             "Density of kerosene";
  parameter Real meuk(unit="lb/ft.s")=0.00168          "Viscosity of  kerosene";
  parameter Real qk(unit="ft^3/s")=1.790               "Volumetric flow rate of kerosene";
  parameter Real D(unit="in")=2.3                      "Diameter of the pipe";
//============================================= 
///////Variable section///////////////////////////
  Real va(unit="ft/s")                                 "Superficial velocity of air";
  Real vk(unit="ft/s")                                 "Superficial velocity of kerosene";
  Real S(unit="ft^2")                                  "Cross sectioinal area";
  Real Rea                                             "Reynolds number of air";
  Real Rek                                             "Reynolds number of kerosene";
//============================================== 
//Equation Section
equation
  S=pi*((D/12)^2)/4;//Converting in to ft
  va=qa/(S*60);
  vk=qk/(S*60);
  Rea=(D/12)*rhoa*va/meua;
  Rek=(D/12)*rhok*vk/meuk;//As Rea >2100 and ReK >2100 The flow is turbulent
end Ex16_6;
//============================================================================


