//J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009. 
// Edition : 1
// Chapter : 17 Prime movers 
// Illustrative Example 17.2 Page Number 201
// Title - Operating condition of the fan
//========================================================================
model Ex17_2
//////Parameter section///////////////////////
//============================================
  parameter Real rpm(unit="rpm")=1694 "Speed of the fan";
  parameter Real q(unit="acfm")=12200 "Volumetric flow rate ";
  parameter Real rpmn(unit="rpm")=2100"New speed of the fan";
  parameter Real P(unit="in H2O")=5   "Static Pressure";
  parameter Real hp(unit="bhp")=9.25  "Power requirement";
//============================================= 
///////Variable section///////////////////////////
  Real Pn(unit="in H2O")              "New static pressure";
  Real qn(unit="acfm")                "New volumetric flow rate" ; 
  Real hpn(unit="bhp")                "New required horse power";
//==============================================
//Equation Section
equation
  qn=q*(rpmn/rpm);
  Pn=P*(rpmn/rpm)^2;
  hpn=hp*(rpmn/rpm)^3;
end Ex17_2;
//============================================================================
