// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,          USA, 2009.
// Edition : 1
// Chapter : 17 Prime movers 
// Illustrative Example 17.4 Page Number 208
// Title - Pressure for the a particular flow rate
//========================================================================
model Ex17_4
//////Parameter section///////////////////////
//============================================
    parameter Real Pc(unit="kPa")=25"Pressure produced by the pump when the valve is closed at 2 m^3/s" ;
    parameter Real Po(unit="kPa")=5"Pressure produced when the valve is open at 2 m^3/s";
    parameter Real q(unit="m^3/s")=1"Volumetric flow rate";
    parameter Real q2(unit="m^3/s")=2"Volumetric flow rate";
//============================================= 
///////Variable section///////////////////////////
    Real P(unit="kPa") "Pressure for the flow rate of 1m^3/s";
    Real a"Constant",b "Constant";
//============================================== 
//Equation Section
equation
    Pc= a- (b*0);//When the valve is closed q = 0 m^3/s
    Po=a -(b*q2^2);
    P=a-(b*q^2);
end Ex17_4;
//============================================================================


