// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 19 Flow measurment
// Illustrative Example 19.1 Page Number 246
// Title - Manometer 
//========================================================================
model Ex19_1
//////Parameter section///////////////////////
//============================================
   parameter Real sgoil=0.8                    "Specific gravity of oil";
   parameter Real sgHg=13.6                    "Specific gravity of Hg";
   parameter Real rhoair(unit="kg/m^3")=1.2    "Density of air";
   parameter Real P7(unit="Pag")=0             "Pressure at Point 7";
   parameter Real g(unit="m/s^2")=9.807        "Accelaration due to gravity";
   parameter Real z3_2(unit="m")=0.4           "The distance between point 2 and 3";
   parameter Real z5_4(unit="m")=1             "The distance between point 4 and 5";
   parameter Real z7_6(unit="m")=0.8           "The distance between point 6 and 7";
   parameter Real rhoH2O(unit="kg/m^3")=1000   "Density of water";
//============================================= 
///////Variable section////////////////////////
   Real rhooil(unit="kg/m^3") "Density of oil"  ;
   Real rhoHg(unit="kg/m^3")  "Density of Hg"  ;
   Real P1(unit="Pag")        "Pressure  at Point 1";
   Real P2(unit="Pag")        "Pressure at Point 2";
   Real P3(unit="Pag")        "Pressure at Point 3";
   Real P4(unit="Pag")        "Pressure at Point 4";
   Real P5(unit="Pag")        "Pressure at Point 5";
   Real P6(unit="Pag")        "Pressure at Point 6";
//============================================== 
//Equation Section
equation
    rhooil=rhoH2O*sgoil;//Converting specific gravity of oil to density of oil
    rhoHg=rhoH2O*sgHg;//Converting specific gravity of Hg to density of Hg
    
    //Applying the manometric equation between point 1 and 2
    P1=P2;//Since rho1=rho2 and z1=z2
    
    //Applying the manometric equation between point 2 and 3
    P2=P3+(rhooil*g*z3_2);//rho2=rho3=rhooil 
    P3=P4;//Since rho3=rho4 and z3=z4
    
    //Applying the manometric equation between point 4 and 5
    P4=P5-(rhoair*g*z5_4);
    P5=P6;//Since rho5=rho6 and z5=z6
    
    //Applying the manometric equation between point 6 and 7
    P6=P7+(rhoHg*g*z7_6);
end Ex19_1;
//============================================================================

