// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 19 Flow measurment
// Illustrative Example 19.3 Page Number 251
// Title - Mass flow rate
//========================================================================
model Ex19_3
/////////Parameter section///////////
//===============================
  parameter Real S(unit="ft^2")= 0.785      "Cross sectional Area" ;
  parameter Real v(unit="ft/s")= 24.4       "Average Velocity" ;
  parameter Real rho(unit="lb/ft^3")= 0.075 "Density of air" ;
//===============================
/////////////Variable section//////////////////////
  Real q(unit="ft^3/min")    "Volumetric flow rate"  ;
  Real m_dot(unit="lb/hr")   "Mass flow rate"       ;
//================================
//Equation section
equation
  q=S*60*v;//Converting s to min 
  m_dot=q*rho*60;//Converting min to hr
end Ex19_3;
//===========================================================================
