// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 20 Ventilation
// Illustrative Example 20.2 Page Number 269
// Title -  Required Diluent volumetric flow rate 
//========================================================================
model Ex20_2
//////Parameter section///////////////////////
//============================================
    parameter Real C(unit="ppm")=100     "Concentration of toluene";
    parameter Real q(unit="gal/h")=3/8   "Volumetric flow rate";
    parameter Real sg=0.87               "Specific gravity";
    parameter Real P(unit="atm")=1       "Pressure";
    parameter Real T(unit="K")=293       "Temperature";
    parameter Real K=5                   "Mixing factor";
    parameter Real Mw(unit="g/gmol")=92                    "Molecular weight of toluene";
    parameter Real R(unit="atm.L/gmol.K")=0.08206          "Gas Constant";
    parameter Real v(unit="gal_toluene/1 gal_adhesive")=0.4"% volume of toluene in adhesive";
//============================================= 
///////Variable section///////////////////////////    
    Real C_a                   "Volume fraction";
    Real q_tol(unit="L/min")   "Volumetric flowrate";
    Real q_dil(unit="ft^3/min")"Diluent volumetric flow rate";
    Real m(unit="lb/h")        "Mass flow rate of toluene";
    Real n(unit="gmol/min")    "Molar flow rate of toluene";
    Real m_g(unit="g/min")     "Mass flow rate in g/min";
//============================================== 
//Equation Section    
equation
    C_a=C*0.8/10^6;//As the threshold limit value is 80 %
    m=q*v*sg*8.34;//Converting sg to density of toluene
    m_g=m*(454/60);//Converting from lb/h to g/min
    n=m_g/Mw;
    q_tol=n*R*T/P;//From ideal gas Law
    q_dil=K*q_tol/(C_a*28.36);//Converting L to ft^3
end Ex20_2;
//=========================================================================
