// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 20 Ventilation
// Illustrative Example 20.8 Page Number 277
// Title - Time to reach a particular concentration
//========================================================================
model Ex20_8
//////Parameter section///////////////////////
//============================================
    parameter Real V(unit="m^3")=142"Volume of room";
    parameter Real q(unit="m^3/min")=12.1"Volumetric flow rate";
    parameter Real r(unit="ng/min")=30"Rate of generation";
    parameter Real ci(unit="ng/m^3")=85"Intial concentration";
    parameter Real co(unit="ng/m^3")=10"Given concentration";
    parameter Real c(unit="ng/m^3")=20.7"Final concentration";
//============================================= 
///////Variable section///////////////////////////    
    Real k(unit="ng/m^3.min")      "Concentration per min";
    Real tou(unit="min")           "time";
    Real t(unit="min")             "Time";
    Real c_steady(unit="ng/m^3")  "Steady state concentration";
//============================================== 
//Equation Section     
equation
    tou=V/q;
    k=r/V;
    c-((co+(k*tou))*(1-(exp(-t/tou))))=ci*(exp(-t/tou));
    c_steady=co+(k*tou);
 end Ex20_8;
//Remark: The  answer provided in the textbook for t is wrong.Calculation error.
//=========================================================================
