// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 21 Academic application
// Illustrative Example 21.10 Page Number 286
// Title - power required by the pump
//========================================================================
model Ex21_10
//////Parameter section///////////////////////
//============================================
    parameter Real  P1(unit="psi")=14.7                "Atmospheric pressure at sea level";
    parameter Real  P2(unit="psi")=10.2                "Atmospheric pressure at 10000 feet";
    parameter Real  z1(unit="ft")=0                    "At sea level";
    parameter Real  z2(unit="ft")=10000                "Height above the sea level";
    parameter Real  rho(unit="lb/ft^3")=62.4           "Density of the fluid";
    parameter Real  m(unit="lb/s")=50                  "Mass flow rate";
    parameter Real  neta=0.65                          "Efficieny";
//============================================= 
///////Variable section///////////////////////////
    Real hs(unit="ft.lbf/lb")"Work delivered by the pump";
    Real h_s(unit="hp")      "Work done";
    Real Wp(unit="hp")        "Actual work";
//============================================== 
//Equation Section
equation
    hs=((P2-P1)*144/rho)+((z2-z1));
    h_s=hs*m/550;//Converting ft.lbf/s to hp
    Wp=h_s/(neta);
end Ex21_10;
//============================================================================
