// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 21 Academic application
// Illustrative Example 21.12 Page Number 288
// Title - Friction loss
//========================================================================
model Ex21_12
//////Parameter section///////////////////////
//============================================
    parameter Real  Kfg=6                        "Loss coefficient for the globe";
    parameter Real  Kft=0.4                      "Loss coefficient for tee";
    parameter Real  v(unit="ft/s")=2.53          "Velocity of the fluid";
    parameter Real  gc(unit="lb.ft/lbf.s^2")=32.2"Conversion constant";
    parameter Real  h_f(unit="psia")=5           "Friction Loss";
    parameter Real  rho(unit="lb/ft^3")=62.4     "Density of the fluid";
//============================================= 
///////Variable section///////////////////////////
    Real hf(unit="ft.lbf/lb")"Friction loss";
//============================================== 
//Equation Section
equation
  hf=(h_f*144/rho)+((2*Kfg)+Kft)*(v^2/(2*gc));//Conversion of psia to psf
end Ex21_12;
//============================================================================
