// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 22 Industrial Applications
// Illustrative Example 22.12 Page Number 311
// Title -  Diameter of the pipe
//========================================================================
model Ex22_12
//////Parameter section///////////////////////
//============================================
    final constant Real pi=Modelica.Constants.pi           "The value of pi";
    parameter Real sg=0.872                                "Specific gravity of the fluid";
    parameter Real Delv(unit="ft/s")=12.66                 "Difference in the velocities";
    parameter Real Z2(unit="ft")=90                        "Height of the discharge end of the pipe";
    parameter Real Z1(unit="ft")=20                        "Height of the top surface in the storage tank";
    parameter Real g(unit="ft/s^2")=32.174                 "Acceleration due to gravity";
    parameter Real neta=0.74                               "Efficiency";
    parameter Real Ws(unit="ft.lbf/lb")=401.9              "Average energy delivered by the pump";
    parameter Real v(unit="ft/s")=12.66                    "Velocity of the fluid";
    parameter Real gc(unit="lb.ft/lbf.s^2")=32.174         "Conversion constant";
//============================================= 
///////Variable section/////////////////////////// 
    Real hf(unit="ft.lbf/lb")                              "Frictional Loss";
    Real D(unit="ft")                                      "Diameter of the pipe";
    Real S(unit="ft^2")                                    "Cross sectional area";
    Real q(unit="ft^3/s")                                  "Volumetric flow rate";
    Real m(unit="lb/s")                                    "Mass flow rate";
    Real bhp(unit="hp")                                    "Brake horse power";
//============================================== 
//Equation Section
equation
   (Delv^2/(2*gc))+(((Z2-Z1)*g)/gc)=(neta*Ws)-hf;//Applying Bernoulli's Equation where there is no pressure drop

//Using the friction factor chart  to determine the Diameter by using the trial and error method
//The two equations are f=0.0293*D and  Re=582250*D 
//Solving with the help of the chart we get D=0.184 ft
    D=0.184;
    S=(pi*D^2)/4;
    q=v*S;
    m=sg*62.4*v*S;//Converting sg to Density of the fluid.
    bhp=(m*Ws/(neta*550));//Converting to hp by dividing with 550
end Ex22_12;
//========================================================================
