// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 22 Industrial Applications
// Illustrative Example 22.16 Page Number 317
// Title -  Power produced due to steam.
//========================================================================
model Ex22_16
    parameter Real z1(unit="ft")=0                   "Position at the inlet";
    parameter Real z2(unit="ft")=-20                 "Position at the outlet";
    parameter Real v1(unit="ft/s")=120               "Velocity at the inlet";
    parameter Real v2(unit="ft/s")=330               "Velocity at the outlet";
    parameter Real H1(unit="Btu/lb")=1505.4          "Enthalpy at the inlet";
    parameter Real H2(unit="Btu/lb")=940             "Enthalpy at the outlet";
    parameter Real Q(unit="Btu/lb")=0                "Heat for adibiatic condition";
    parameter Real gc(unit="lb.ft/lbf.s^2")=32.17    " Conversion constant";
    parameter Real g(unit="ft/s^2")=32.17            "Acceleration due to gravity";
    parameter Real m(unit="lb/h")=450000             "Mass flow rate";
//============================================= 
///////Variable section///////////////////////////
    Real Ws(unit="Btu/lb")                             "Work generated in the system";
    Real W_s(unit="Btu/h")                             "Total  power generated";
    Real W_hp(unit="hp")                               "Power generated in hp";
//============================================== 
//Equation Section     
equation
    (z1*(g/gc))+((v1^2)/(2*gc*778))+H1+Q=((z2/778)*(g/gc))+((v2^2)/(2*gc*778))+H2+Ws;
    W_s=m*Ws;
    W_hp=W_s*3.927E-4;//Converting Btu/h to hp
end Ex22_16;
//========================================================================
