// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 22 Industrial Applications
// Illustrative Example 22.6 Page Number 301
// Title -  Calculate the head
//========================================================================
model Ex22_6
//////Parameter section///////////////////////
//============================================
    parameter Real pi=Modelica.Constants.pi             "The value of pi";
    parameter Real vgal(unit="gal/hr")=400              "Volumetric flow rate";
    parameter Real Do(unit="in")=1                      "Diameter of the orifice";
    parameter Real sg=0.87                              "Specific graity of the oil";
    parameter Real meu(unit="cP")=20.6                  "Viscosity of the fluid";
    parameter Real Co=0.76                              "Discharge coefficient";
    parameter Real g(unit="ft/s^2")=32.2                "Acceleration due to gravity";
    parameter Real D1(unit="in")=1.61                   "Diameter of the pipe";
//============================================= 
///////Variable section/////////////////////////// 
    Real S(unit="in^2")                                 "Cross sectional area at the orifice";
    Real h(unit="ft of oil")                            "Height rise of oil in gauge reading" ;
    Real vo(unit="ft/s")                                "Orifice velocity in ft/s";
    Real Re                                             "Reynolds number";
//============================================== 
//Equation Section    
equation
    S=pi/4*Do^2;
    vo=vgal*144/(S*3600*7.48);//Conversion of hr to s and in^2 to ft^2
    Re=(Do*vo*sg*62.4/12)/(meu*0.000672);//Converting in to ft and cP to kg/m.s
    h=((vo^2)/(2*g*(Co^2)))*(1-((Do/D1)^4));
end Ex22_6;
//=============================================================================
