// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 22 Industrial Applications
// Illustrative Example 22.7 Page Number 302
// Title -  Calculate the head
//========================================================================
model Ex22_7
//////Parameter section///////////////////////
//============================================
    final constant Real pi=Modelica.Constants.pi              "The value of pi";
    parameter Real Do(unit="in")=2.5                          "Diameter of orifice";
    parameter Real rho(unit="lb/ft^3")=0.054                   "Density of the flowing fluid";
    parameter Real g(unit="ft/s^2")=32.2                      "Acceleration due to gravity";
    parameter Real h(unit="in H2O")=1.6                       "Manometer reading";
    parameter Real rho_m(unit="lb/ft^3")=62.4                 "Density of Manometer fluid";
    parameter Real meu(unit="cP")=0.011                       "Viscosity  of fluid";
    parameter Real D1(unit="in")=10.15                        "Diameter of pipe";
    parameter Real Co=0.61                                    "Coefficient of discharge ";
//============================================= 
///////Variable section///////////////////////////
    Real Re                                                  "Reynolds number";
    Real vo(unit="ft/s")                                     "Orifice velocity";
    Real m(unit="lb/hr")                                     "Mass flow rate";
    Real ratio                                               "Ratio of orfice to pipe diameter";
//============================================== 
//Equation Section
equation
    ratio=Do/D1;
    vo=Co*(((2*g*h*(rho_m))/(12*rho))^0.5);//Convering in to ft 
    Re=(Do*vo*rho/12)/(meu*0.000672);
    m=vo*((pi/4)*(Do^2))*rho*(3600/144); 
end Ex22_7;
//=============================================================================
