// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 23 Particle dynamics 
// Illustrative Example 23.1 Page Number 323
// Title - Aerodynamic diameter
//========================================================================
//////Parameter section///////////////////////
//============================================
model Ex23_1
    parameter Real Ds(unit="micrometer")=1.4 "Equivalent diameter for solid sphere";
    parameter Real sgs=2                     "Specific gravity for solid sphere";
    parameter Real Dh(unit="micrometer")=2.8 "Equivalent diameter for hollow sphere";
    parameter Real sgh=0.51                  "Specific gravity for hollow sphere";
//============================================= 
///////Variable section///////////////////////////    
    Real dpa1(unit="micrometer")               "Aerodynamic diameter for solid sphere";
    Real dpa2(unit="micrometer")               "Aerodynamic diameter for hollow sphere";
//============================================== 
//Equation Section
equation
    dpa1=Ds*(sgs^0.5);
    dpa2=Dh*(sgh^0.5);
end Ex23_1;
//============================================================================  
