// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,          USA, 2009.
// Edition : 1
// Chapter : 23 Particle dynamics 
// Illustrative Example 23.3 Page Number 335
// Title - Cunningham correction factor
//========================================================================
model Ex23_3
//////Parameter section///////////////////////
//============================================
    parameter Real dp(unit="micrometer")=0.4 "Diameter of the particle";
    parameter Real lamda(unit="micrometer")=6.53E-2 "Mean free path of the fluid molecule";
    parameter Real d_p[9](each unit="micrometer")={0.001,0.01,0.1,0.25,0.5,1,2.5,5,10} "Diameter of the particle";
//============================================= 
///////Variable section///////////////////////////
    Real C70[9]                                           "Cunningham correction factor at 70 degF";
    Real A                                                "Experimental coefficient";
    Real C                                                "Cunningham correction factor";
//============================================== 
//Equation Section
equation
  for i in 1:9 loop
  C70[i]=1+(2*(1.257+(0.4*exp(-1.10*d_p[i]/(2*lamda))))*lamda/d_p[i]);
  end for;
//The sample calculation :
  A=1.257+(0.4*exp(-1.10*dp/(2*lamda)));
  C=1+(2*A*lamda/dp);
end Ex23_3;
//Remark : The C for 212 degF and C for 500 degF is not caluclated as the mean free path at that temperature is not mentioned in the sum. 
//============================================================================  

