// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 23 Particle dynamics 
// Illustrative Example 23.5 Page Number 338
// Title - Size of fly ash particle
//========================================================================
model Ex23_5
//////Parameter section///////////////////////
//============================================
    parameter Real rho_a(unit="lb/ft^3")=0.0569                    "Density of air";
   parameter Real rho_p(unit="lb/ft^3")=144.14                     "Density of the particle";
    parameter Real meu(unit="lb/ft.s")=1.41E-5                     "Viscosity of the fluid";
    parameter Real g(unit="ft/s^2")=32.2                             "Acceleration due to gravity";
    parameter Real v(unit="ft/s")=1.384                            "Velocity";
///////Variable section///////////////////////////
//=============================================    
    Real W                                                         "Dimensionless number";
    Real Dp(unit="ft")                                             "Diameter of the particle";
//==============================================
//Equation Section
equation
    W=((v^3)*(rho_a^2))/(g*rho_p*meu);//As W <0.2222 Stokes Law is being applied.
    Dp=((18*meu*v)/(g*rho_p))^0.5;
end Ex23_5;
//============================================================================  
