// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 23 Particle dynamics 
// Illustrative Example 23.8 Page Number 342
// Title - Terminal settling  velocity
//========================================================================
model Ex23_8
//////Parameter section///////////////////////
//============================================
    final constant Real pi= Modelica.Constants.pi"The value of pi";
    parameter Real vt(unit="m/s")=0.042          "Terminal velocity of oil";
    parameter Real meu(unit="kg/m.s")=0.9        "Viscosity of the oil";
    parameter Real rho_f(unit="kg/m^3")=970      "Density of the castor oil";
    parameter Real g(unit="m/s^2")=9.807         "Acceleration due to gravity";
    parameter Real dp(unit="m")=0.006            "Diameter of particle";
    parameter Real vf(unit="m^2/s")=9.28E-4     "Kinematic viscosity";
    parameter Real meu_w(unit="kg/m.s")=0.001    "Viscosity of water";
    parameter Real rho_w(unit="kg/m^3")=1000     "Density of water";
//============================================= 
///////Variable section///////////////////////////
    Real Kw                  "Settling criterion factor";
    Real Re                  "Reynolds number";
    Real rho_p(unit="kg/m^3")"Density of the particle";
    Real Cd                  "Drag coefficient";
    Real K                   "Settling criterion factor";
    Real Fd(unit="N")        "Drag force";
    Real Fb(unit="N")        "Buoyancy force";
    Real v_t(unit="m/s")     "Terminal settling velocity";
//============================================== 
//Equation Section
equation
    rho_p=((18*meu*vt)/(g*(dp^2)))+rho_f;
    Re=dp*vt/vf;//Stokes Law is applicable as Re <0.3
    K=dp*(((g*(rho_p-rho_f)*rho_f)/(meu^2))^(1/3));//Stokes Law applies as K<3.3
    Cd=24/Re;
    Fd=(3*pi*meu*dp*vt);
    Fb=(pi*(dp^3)*rho_f*g)/6;
    Kw=dp*(((g*(rho_p-rho_w)*rho_w)/(meu_w^2))^(1/3));//Printing mistake in the value of rhow for this eqn in the book.
//As Kw >43.6 The Newtons Law regime apply
    v_t=1.75*((((rho_p-rho_w)*g*dp)/rho_w)^0.5);
end Ex23_8;
//============================================================================
