// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 23 Particle dynamics 
// Illustrative Example 23.9 Page Number 344
// Title - Drag on the bottom of the ship
//========================================================================
model Ex23_9
//////Parameter section///////////////////////
//============================================
    parameter Real rho(unit="kg/m^3")=1000           "Density of the fluid";
    parameter Real v(unit="m/s")=12                  "Velocity of the boat";
    parameter Real L(unit="m")=20                    "Length";
    parameter Real W(unit="m")=5                     "Width";
    parameter Real meu(unit="N/s.m^2")=1E-3          "Viscosity of the fluid";
//============================================= 
///////Variable section///////////////////////////
    Real Re                                          "Reynolds number";
    Real Cd                                          "Drag coefficient";
    Real Fd(unit="N")                                "Drag force";
//============================================== 
//Equation Section
equation
    Re=rho*v*L/meu;//As Re >2100 The flow is turbulent.
    Cd=0.031/(Re^(1/7));
    Fd=0.5*Cd*rho*(v^2)*L*W;
end Ex23_9;
//============================================================================ 
