// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 24 Sedimentation,Centrifugation and flotation
// Illustrative Example 24.1 Page Number 350
// Title - Effective viscosity of the mixture and terminal velocity
//========================================================================
model Ex24_1
//////Parameter section///////////////////////
//============================================
    parameter Real mf(unit="kg")=40                  "Mass of the fluid";
    parameter Real rhof(unit="kg/m^3")=998           "Density of the fluid";
    parameter Real ms(unit="kg")=60                  "Mass of the solid";
    parameter Real rhos(unit="kg/m^3")=2467          "Density of solid";
    parameter Real g(unit="m/s^2")=9.807             "Acceleration due to gravity";
    parameter Real dp(unit="m")=0.0001554            "Diameter of the particle";
    parameter Real meuf(unit="kg/m.s")=0.001         "Viscosity of the fluid";
//============================================= 
///////Variable section///////////////////////////    
    Real Vf(unit="m^3")                              "Volume of the fluid";
    Real Vs(unit="m^3")                              "Volume of the solid";
    Real V(unit="m^3")                               "Total volume";
    Real e_f                                         "Volume fraction for the fluid particle";
    Real e_p                                         "Volume fraction for the solid particle";
    Real rhom(unit="kg/m^3")                         "Bulk density of the slurry";
    Real b                                           "Dimensionless correction factor";
    Real v(unit="m/s")                               "Terminal settling velocity";
    Real meum(unit="kg/m.s")                         "Mixture viscosity";
//============================================== 
//Equation Section
equation
    Vf=mf/rhof;
    Vs=ms/rhos;
    V=Vf+Vs;
    e_f=Vf/V;
    e_p=1-e_f;
    rhom=(e_p*rhos)+(e_f*rhof);
    b=10^(1.82*(1-e_f));
    v=(g*(dp^2)*(rhos-rhof)*(e_f^2))/(18*meuf*b);
    meum=meuf*b;
end Ex24_1;
//============================================================================
