// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 24 Sedimentation,Centrifugation and flotation
// Illustrative Example 24.10 Page Number 362
// Title - Maximum diameter of the droplet
//========================================================================
model Ex24_10
//////Parameter section///////////////////////
//============================================
  final constant Real pi=Modelica.Constants.pi  "The value of pi";
  parameter Real q(unit="ft^3/min")=4           "Volumetric flow rate";
  parameter Real D(unit="in")=2.5               "Diameter of the pipe";
  parameter Real rho(unit="lb/ft^3")=0.0775     "Density of the fluid";
  parameter Real meu(unit="lb/ft.s")=1.23E-5    "Viscosity of the fluid";
  parameter Real sg=1.34                        "Specific gravity  of the particle";
  parameter Real g(unit="ft/s^2")=32.2          "Acceleration due to gravity";
//============================================= 
///////Variable section///////////////////////////
  Real v(unit="ft/s")                           "Velocity of air ";
  Real dp(unit="ft")                            "Diameter of the particle";
  Real K                                        "Settling factor";
//============================================== 
//Equation Section
equation
  v=q/(60*(pi/4)*((D/12)^2));//Converting min to s, in to ft
  (dp^1.14)=((v*(rho^0.29)*(meu^0.43))/(0.153*((g*sg*62.4)^0.71)));//Converting sg to density of particle
  K=dp*(((g*rho*sg*62.4)/(meu^2))^(1/3));//As 3.3<K<43.6 The assumption is valid.
end Ex24_10;//============================================================================
