// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 25 Porous media and packed beds
// Illustrative Example 25.1 Page Number 370
// Title - Effective particle diameter
//========================================================================
model Ex25_1
//////Parameter section///////////////////////
//============================================
    parameter Real V(unit="mL")=0.2"Packing volume";
    parameter Real n=100"Number of particles";
    parameter Real Sp(unit="mm^2")=2.18"Average surface area";
//============================================= 
///////Variable section///////////////////////////    
    Real ap(unit="mm^-1")"specific surface area";
    Real Vp(unit="mm^3") "Volume of a single particle";
    Real Dp(unit="mm")   "Particle diameter";
//============================================== 
//Equation Section
equation
    Vp=(V*1000)/n;//Converting to mm^3
    ap=Sp/Vp;
    Dp=6/ap;
end Ex25_1;
//Remark: The units providied for Vp in the textbook is wrong.Printing mistake.
//=========================================================================
