// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 25 Porous media and packed beds
// Illustrative Example 25.3 Page Number 372
// Title - Effective particle diameter
//========================================================================
model Ex25_3
//////Parameter section///////////////////////
//============================================
    final constant Real pi= Modelica.Constants.pi     "The value of pi";
    parameter Real dp(unit="cm")=1.5                  "Diameter of cylinderical particle";
    parameter Real h(unit="cm")=2.5                   "Height";
//============================================= 
///////Variable section///////////////////////////
    Real Vp(unit="cm^3")                              "Volume of cylindrical particles";
    Real Sp(unit="cm^2")                              "Surface area";
    Real ap(unit="cm^-1")                             "Particle specific surface";
    Real dpe(unit="cm")                               "Effective particle diameter";
//============================================== 
//Equation Section    
equation
    Vp=(pi*(dp^2)*h)/4;
    Sp=(pi*dp*h)+(2*pi*(dp^2)/4);
    ap=Sp/Vp;
    dpe=6/ap;
end Ex25_3;
//=========================================================================
