//J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.USA, 2009.
// Edition : 1
// Chapter : 26 Fluidization
// Illustrative Example 26.3 Page Number 384
// Title - Pressure drop due to friction
//========================================================================
model Ex26_3
//////Parameter section///////////////////////
//============================================
  parameter Real hf(unit="ft")=1.25              "Frictional Loss";
  parameter Real e=0.25                          "bed porosity";
  parameter Real dp(unit="ft")=0.00417           "Diameter of the particle";
  parameter Real rho(unit="lb/ft^3")=62.4        "Density of the fluid";
  parameter Real z2_z3(unit="ft")=-1"Height difference between point 2 and 3";
//============================================= 
///////Variable section///////////////////////////
  Real k(unit="Darcies") "packed bed permeability";
  Real DelP_fr(unit="psf")"Frictional Pressure drop";
  Real DelP(unit="psf")"Pressure drop due to the height of the fluid";
//============================================== 
//Equation Section
equation
 k=(((e^3)*(dp^2))/(150*((1-e)^2)))/(1.06E-11);//Using eqn 26.21 and Converting ft^2 to Darcies
 DelP_fr=(rho*hf);
 DelP = (z2_z3+hf)*rho;//Applying Bernoulli's equation between point 2 and 3
end Ex26_3;
//Remark :The answer provided for k in the textbook is wrong.Calculation error during unit conversion.
//============================================================================
